-1--Rename the existing requesttype table to datatype--

exec sp_rename 'dbo.RequestType', 'DataType'


-2-- Create table RequestType--

CREATE TABLE [dbo].[RequestType] (
    [Id]          INT          NOT NULL,
    [Description] VARCHAR (50) NULL
);



-3--Insert data into RequestType--

INSERT INTO [dbo].[RequestType] ([Id] ,[Description]) VALUES (1, 'VINCI Data Request ')
INSERT INTO [dbo].[RequestType] ([Id],[Description]) VALUES (2, 'Transfer to VINCI Request ')

-4----UPDATE Role_Type Table--

UPDATE [GENISIS_DB].[dbo].[Role_Type] set Role_Name='Genisis2 Manager', Role_Description='Genisis2 Manager' where Role_Type_id=3
UPDATE [GENISIS_DB].[dbo].[Role_Type] set Role_Name='VINCI Manager', Role_Description='VINCI Manager' where Role_Type_id=4


-5----CHANGE SourceId to NULL in Request and Requesthistory--


ALTER TABLE RequestHistory
ALTER COLUMN SourceId INT NULL;

ALTER TABLE Request
ALTER COLUMN SourceId INT NULL;


-6--
--Add new column to request and requestHistory


ALTER TABLE Request
ADD DataTypeId int null;

ALTER TABLE RequestHistory
ADD DataTypeId int null;





-7----CREATE TABLE FOR FILE ATTACHMENT--

 CREATE TABLE [dbo].[Attachment](
[AttachmentId] [int] NOT NULL,
[RequestId] [int] NOT NULL,
[StatusId] [int] NOT NULL,
[FileName] [varchar](128) NOT NULL,
[FileType] [varchar](50) NOT NULL,
[FileData] [varbinary](max) NOT NULL,
[TaskId] [varchar](50) NULL,
[ActionType] [varchar](50) NULL,
[CreatedBy] [varchar](50) NOT NULL,
[CreatedOn] [datetime] NULL,
CONSTRAINT [PK_Attachment] PRIMARY KEY CLUSTERED 
(
[AttachmentId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
ALTER TABLE [dbo].[Attachment] WITH CHECK ADD CONSTRAINT [FK_Attachment_Attachment] FOREIGN KEY([StatusId])
REFERENCES [dbo].[WorkflowStatus] ([Id])
GO
ALTER TABLE [dbo].[Attachment] CHECK CONSTRAINT [FK_Attachment_Attachment]
GO
ALTER TABLE [dbo].[Attachment] WITH CHECK ADD CONSTRAINT [FK_Attachment_Request] FOREIGN KEY([RequestId])
REFERENCES [dbo].[Request] ([Id])
GO
ALTER TABLE [dbo].[Attachment] CHECK CONSTRAINT [FK_Attachment_Request]


-8-- MAKE CHANGES FOR PRIMARY KEYS AND FOREIGN KEYS IN RESPECTIVE TABLES--


ALTER TABLE RequestType
ADD PRIMARY KEY (Id);

ALTER TABLE Request
DROP CONSTRAINT Fk_RqId --WHATEVER THE CONSTRAINT NAME IS IN THE DATABASE--

ALTER TABLE [dbo].[Request]  WITH CHECK ADD  CONSTRAINT [Fk_RqId] FOREIGN KEY([RequestTypeId])
REFERENCES [dbo].[RequestType] ([Id])
GO

ALTER TABLE DataType
DROP CONSTRAINT PK_RequestType

ALTER TABLE [dbo].[DataType] ADD  CONSTRAINT [PK_DataType] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO


ALTER TABLE [dbo].[Request]  WITH CHECK ADD  CONSTRAINT [Fk_datatypeId] FOREIGN KEY([DataTypeId])
REFERENCES [dbo].[DataType] ([Id])
GO


-9--UPDATE THE DATATYPE DESCRIPTION FIELD--


update datatype
set Description='Aggregate Data'
where id=1

update datatype
set Description='Detail Data'
where id=2


-10--UPDATE SOURCE DESCRIPTION FIELD--


UPDATE Source
Set Description ='Genomic Data'
where id=2

UPDATE Source
Set Description ='Survey Data'
where id=1


-11-- INSERT OPERATIONS INTO STUDY APPROVAL TABLE--



INSERT [dbo].[StudyApproval] ([Id], [ProcessId], [ApprovalIdObtained], [AssociatedStudyApproval1], [AssociatedStudyApproval2], [AssociatedStudyApproval3], [Title], [Description], [CreatedOn], [ModifiedOn], [CreatedBy], [ModifiedBy]) VALUES (1, 0, NULL, NULL, NULL, NULL, N'Operations', N'Operations', CAST(0x0000A7F000BE86B4 AS DateTime), CAST(0x0000A7F000BE86B4 AS DateTime), N'researcher1', NULL)
GO

-12--CREATE TABLE FIELDTOOL DESCRIPTION AND INSERT DATA INTO IT--

create table
[dbo].[Field_ToolTip_Description](
   [Id] [int] NOT NULL PRIMARY KEY,
   [FieldName] [varchar](50) NOT NULL,
   [TextDescription] [varchar](4000) NOT NULL)


CREATE UNIQUE NONCLUSTERED INDEX IDX_fieldname ON Field_Tooltip_description (fieldname)



INSERT [dbo].[Field_ToolTip_Description] ([Id], [FieldName], [TextDescription]) VALUES (1, N'VINCI_REQUEST_Description', N'Provide the following information:
 Data source URI
 Data destination URI
 Data Description

URI can be :
 file://<file-server-or-empty-string>/full/path/to/file
 mssql://<db-server-or-empty-string>/database/schema/table_or_view')
GO
INSERT [dbo].[Field_ToolTip_Description] ([Id], [FieldName], [TextDescription]) VALUES (2, N'TRANSFER_TO_VINCI_REQUEST_Description', N'Provide the following information:
 Data source URI
 Data destination URI
 Data Description

URI can be :
 file://<file-server-or-empty-string>/full/path/to/file
 mssql://<db-server-or-empty-string>/database/schema/table_or_view')
GO


-13---CHANGES FOR USER REFRESHHISTORY--

ALTER TABLE UserRefreshHistory
ADD TableName VARCHAR(50) NULL;

Update UserRefreshHistory
Set TableName='Users'

ALTER TABLE UserRefreshHistory
ALTER COLUMN TableName VARCHAR(50) not null;



--14--CHANGES FOR StudyApproval--

ALTER TABLE StudyApproval
ADD Active tinyint NULL

Update StudyApproval
Set Active=1

ALTER TABLE StudyApproval
ALTER COLUMN Active tinyint NOT NULL;


ALTER TABLE StudyApproval
ADD Active_date datetime NULL;

Update StudyApproval
Set Active_date=GETDATE()

Alter TabLe StudyApproval
ALTER COLUMN Active_date datetime NOT NULL;

Alter table StudyApproval
Add Inactive_date datetime NULL;


--CHANGES FOR USERREFRESHHISTORY---

exec sp_rename 'UserRefreshHistory', 'RefreshHistory'


EXEC sp_rename 'RefreshHistory.TableName', 'JobType', 'COLUMN';



-15--CREATE TABLE FOR USERmanagementDashboard--

CREATE TABLE [dbo].[UserManagementDashboard] (
    [Id]          INT          NOT NULL PRIMARY KEY,
    [Description] VARCHAR (50) NOT NULL
);


INSERT INTO [dbo].[UserManagementDashboard] ([Id] ,[Description]) VALUES (1, 'User Management ')
INSERT INTO [dbo].[UserManagementDashboard] ([Id],[Description]) VALUES (2, 'Data Request Metrics ')


